# Contributing to ALTCHA

We appreciate your contributions! To ensure a smooth and transparent collaboration, we've outlined the various ways you can contribute to ALTCHA:

- **Reporting a Bug**
- **Discussing the Current State of the Code**
- **Submitting a Fix**
- **Proposing New Features**
- **Becoming a Maintainer**

## Development with GitHub

ALTCHA is hosted on GitHub, where you can find the codebase, track issues, and submit pull requests. Please familiarize yourself with GitHub for effective collaboration.

## Project Technology: Svelte

ALTCHA utilizes [Svelte](https://svelte.dev) for its Web Component widget. Refer to Svelte's documentation to set up your development environment.

## Licensing Information

Any contributions you make will be subjected to the project's MIT software license. By submitting code changes, you agree to license your contributions under the same [MIT License](http://choosealicense.com/licenses/mit/) that covers the entire project. If you have any concerns regarding licensing, feel free to reach out to the maintainers.

## Reporting Bugs Using GitHub's [Issues](https://github.com/altcha-org/altcha-lib-php/issues)

We track public bugs using GitHub issues. Reporting a bug is easy: simply [open a new issue](https://github.com/altcha-org/altcha-lib-php/issues). Provide detailed information for effective bug resolution.

## Writing Effective Bug Reports

Good bug reports include:

- A quick summary and background of the issue
- Steps to reproduce the problem
  - Be specific!
  - Include sample code if possible
- Expected vs. actual outcomes
- Additional notes, such as your hypotheses or unsuccessful attempts to resolve the issue

## License Agreement

By contributing to ALTCHA, you agree that your contributions will be licensed under the project's MIT License. If you have any questions or concerns, please reach out to the maintainers.
